<?php

/**
 * This is the model class for table "Akcja".
 *
 * The followings are the available columns in table 'Akcja':
 * @property double $id
 * @property string $nazwa
 * @property double $idLekcji
 * @property double $idRodzica
 * @property double $czyObowiazkowa
 * @property double $czyOglaszac
 * @property double $czyGlobalna
 * @property double $czyWiadomosc
 * @property string $naglowek
 * @property string $tresc
 * @property double $czyPracaDomowa
 * @property string $aktywneWnetrza
 * @property double $czyAutomatyczna
 */
class Akcja extends CActiveRecord
{
	const ACTION_TENDER = 'przetarg';
	const ACTION_MAIL = 'mail';
	const ACTION_PAYMENTS = 'oplaty';

	private static $interiors;

	public $dataWykonania;
	public $poziom;

	public static function getInteriors()
	{
		if (self::$interiors == null)
			self::$interiors = Yii::app()->db
				->createCommand('SELECT "value" FROM "SlownikWnetrz" ORDER BY "value"')->queryAll(true);
		return self::$interiors;
	}

	public function save($runValidation = true, $attributes = NULL)
	{
		//store new interior names
		$values = array();
		foreach (explode(',', $this->aktywneWnetrza) as $interior) {
			$interior = trim($interior);
			if (!empty($interior)) {
				$values[$interior] = $interior;
				Yii::app()->db->createCommand('INSERT
					/*+ ignore_row_on_dupkey_index("SlownikWnetrz", "SlownikWnetrz_IDX_UK_value") */
					INTO "SlownikWnetrz" ("value") VALUES (:interior)')->execute(array(
					':interior' => $interior
				));
			}
		}
		$this->aktywneWnetrza = join(',', $values);
		return parent::save($runValidation, $attributes);
	}

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Akcja the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Akcja';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idLekcji, idRodzica, czyObowiazkowa, czyOglaszac, czyGlobalna, czyWiadomosc, czyPracaDomowa, czyAutomatyczna', 'numerical'),
			array('nazwa', 'length', 'max'=>60),
			array('naglowek', 'length', 'max'=>255),
			array('tresc', 'length', 'max'=>4000),
			array('aktywneWnetrza', 'length', 'max'=>4000),
			array('id, nazwa, idLekcji, idRodzica, czyObowiazkowa, czyOglaszac, czyGlobalna, czyWiadomosc, naglowek, tresc, czyPracaDomowa, aktywneWnetrza, czyAutomatyczna', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'lekcja'=>array(self::BELONGS_TO, 'Lekcja', 'idLekcji'),
			'userAction'=>array(self::HAS_ONE, 'AkcjaUzytkownika', 'idAkcji',
				'on' => '"t"."id" = "userAction"."idAkcji" and "userAction"."idUzytkownika" = :userId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Akcja', 'ID'),
			'nazwa'=>Yii::t('Akcja', 'Nazwa'),
			'idLekcji'=>Yii::t('Akcja', 'Lekcja'),
			'idRodzica'=>Yii::t('Akcja', 'Rodzic'),
			'czyObowiazkowa'=>Yii::t('Akcja', 'Obowiązkowa'),
			'czyOglaszac'=>Yii::t('Akcja', 'Ogłaszać'),
			'czyGlobalna'=>Yii::t('Akcja', 'Globalna'),
			'czyWiadomosc'=>Yii::t('Akcja', 'Wiadomość'),
			'naglowek'=>Yii::t('Akcja', 'Nagłówek'),
			'tresc'=>Yii::t('Akcja', 'Treść'),
			'czyPracaDomowa'=>Yii::t('Akcja', 'Praca domowa'),
			'aktywneWnetrza'=>Yii::t('Akcja', 'Aktywne wnętrza'),
			'czyAutomatyczna'=>Yii::t('Akcja', 'Czy automatyczna')
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare(Yii::app()->db->quoteColumnName('id'), $this->id);
		$criteria->compare('LOWER("nazwa")', strtolower($this->nazwa), true);
		$criteria->compare(Yii::app()->db->quoteColumnName('idLekcji'), $this->idLekcji);
		$criteria->compare(Yii::app()->db->quoteColumnName('idRodzica'), $this->idRodzica);
		$criteria->compare(Yii::app()->db->quoteColumnName('czyObowiazkowa'), $this->czyObowiazkowa);
		$criteria->compare(Yii::app()->db->quoteColumnName('czyOglaszac'), $this->czyOglaszac);
		$criteria->compare(Yii::app()->db->quoteColumnName('czyGlobalna'), $this->czyGlobalna);
		$criteria->compare(Yii::app()->db->quoteColumnName('czyWiadomosc'), $this->czyWiadomosc);
		$criteria->compare('LOWER("naglowek")', strtolower($this->naglowek), true);
		$criteria->compare('LOWER("tresc")', strtolower($this->tresc), true);
		$criteria->compare(Yii::app()->db->quoteColumnName('czyPracaDomowa'), $this->czyPracaDomowa);
		$criteria->compare(Yii::app()->db->quoteColumnName('czyAutomatyczna'), $this->czyAutomatyczna);

		$criteria->addCondition('"idRodzica" IS NULL');

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getRoot()
	{
		$sql = 'SELECT "rootId"
			FROM (
				SELECT "id" as "rootId"
				FROM "Akcja"
				START WITH "id" = '.$this->id.'
				CONNECT BY PRIOR "idRodzica" = "id"
				ORDER BY LEVEL DESC
			)
			WHERE rownum <=1';

		return Akcja::model()->find('"id"=('.$sql.')');
	}

	public function getActionsThree($editOptions=null)
	{
		$sql = 'SELECT *
			FROM "Akcja"
			START WITH "id" = :id
			CONNECT BY PRIOR "id" = "idRodzica"
			ORDER BY LEVEL';

		$three = Yii::app()->db->createCommand($sql)->queryAll(true,array(':id'=>$this->id));

		$actionsRows = array();

		$rootId = 0;

		foreach($three as $statement)
		{
			if(empty($statement['idRodzica']))
				$rootId = $statement['id'];

			$actionsRows[$statement['id']] = $statement;
		}

		$actionsThree = $this->buildThree($actionsRows,$rootId,$editOptions);

		return array($actionsThree);
	}

	public function getActionsEditThree()
	{
		return $this->getActionsThree(true);
	}

	public function buildThree($data,$currentNodeId,$editOptions=null)
	{
		$returnArray = array();
		$childrenArray = array();

		foreach($data as $statement)
		{
			if($statement['idRodzica'] == $currentNodeId)
			{
				$three = $this->buildThree($data,$statement['id'],$editOptions);
				if(!empty($three))
					$childrenArray[] = $three;
			}
		}

		$returnArray['text'] = '<b>#'.$data[$currentNodeId]['id'].'</b>
					<b>Nazwa:</b> <i>"'.$data[$currentNodeId]['nazwa'].'"</i><br />
					<b>Nagłówek:</b> <i>'.$data[$currentNodeId]['naglowek'].'</i><br />';

//		if($editOptions)
//			$returnArray['text'] .= '<a href="'.Yii::app()->createUrl('/administration/akcja/createChildAction',array('parentId'=>$data[$currentNodeId]['id'])).'">Dodaj akcję</a>
//				| <a href="'.Yii::app()->createUrl('/administration/akcja/updateAction',array('id'=>$data[$currentNodeId]['id'])).'">Edytuj tą akcję</a>
//				| '.CHtml::link('Usuń tą akcję (i wszystkie jej potomki)', array('/administration/akcja/delete','id'=>$data[$currentNodeId]['id']), array('confirm' => 'Czy na pewno chcesz usunąć tą akcję i wszystkie jej potomki?')).'<br />';

		if($editOptions)
			$returnArray['text'] .= '<a href="'.Yii::app()->createUrl('/administration/akcja/updateAction',array('id'=>$data[$currentNodeId]['id'])).'">Edytuj tą akcję</a><br />'; //pelna wersja wyzej

		if(!empty($childrenArray))
			$returnArray['children'] = $childrenArray;

		$returnArray['expanded'] = true;

		return $returnArray;
	}

	//deletes current model and all of its children
	public function deleteChildren()
	{
		$sql = 'DELETE FROM "Akcja" WHERE "id" IN (SELECT "id"
			FROM "Akcja"
			START WITH "id" = '.$this->id.'
			CONNECT BY PRIOR "id" = "idRodzica")';

		Yii::app()->db->createCommand($sql)->execute();
	}

	const INTERIOR_CACHE_INTERVAL = 10;

	public static function getAllowedInteriors()
	{
		$turaId = Yii::app()->user->getState('tura');
		$companyId = Yii::app()->user->getState('id_firmy');

		// pobierz pierwszą akcję dla tej lekcji
		$akcja = Akcja::model()->find(array(
			'condition'=>'"idRodzica" IS NULL AND "idLekcji" = :idLekcji',
			'params'=>array(':idLekcji'=>$turaId),
		));

		// pobierz ostatnią zapisaną obowiązkową akcję dla tego użytkownika
		$wybranaAkcja = AkcjaUzytkownika::model()->with(array('akcja','uzytkownik'))->find(array(
			'condition' => '"dataWykonania" is not null AND "akcja"."czyObowiazkowa" > 0 AND "akcja"."idLekcji" = :idLekcji AND "uzytkownik"."idFirmy" = :idFirmy',
			'order' => '"dataWyslania" DESC',
			'params' => array(
				':idFirmy' => $companyId,
				':idLekcji' => $turaId
		)));

		// ====
		// TODO sprawdzic tu jeszcze wczesniejsze akcje
		// ====

		$INTERIORS = array();

		if(isset($wybranaAkcja) && $turaId > 0)
		{
			$INTERIORS = array_flip(explode(',', $wybranaAkcja->akcja['aktywneWnetrza']));
		}
		else
		{
			$INTERIORS = array_flip(explode(',', $akcja['aktywneWnetrza']));
		}

		if(!Yii::app()->user->getState('tura_aktywna') && $turaId > 0)
		{
			foreach($INTERIORS AS $Key => $Value) {
				unset($INTERIORS[$Key]);
			}

			$INTERIORS['skrzynka'] = 1;
			$INTERIORS['zlecenia'] = 2;
			$INTERIORS['komputer'] = 3;

			if($turaId >= 5)
			{
				$INTERIORS['finanse'] = 4;
				$INTERIORS['dokumenty'] = 5;
			}
		}

		return $INTERIORS;
	}

	public static function isLessonActive()
	{
		return Yii::app()->user->tura_aktywna || ParametryGry::getValue('CZY_TRYB_DEMO', 0);
	}

	public static function isLessonInactive()
	{
		return !Yii::app()->user->tura_aktywna || ParametryGry::getValue('CZY_TRYB_DEMO', 0) == 0;
	}

	/**
	 * Sprawdz czy uzytkownik (uczeń) ma prawo wyswietlić podane wnętrze
	 * na podstawie obecnej trwającej lub nie lekcji.
	 * @param string|array $interior Nazwa(y) wnętrz(a)
	 * @return boolean Czy mozna wyświetlic wnętrze przy obecnej lekcji
	 */
	public static function isInteriorAllowed($interior)
	{
		if (!is_array($interior))
			$interior = array($interior);
		$interior = array_flip($interior);

		$INTERIORS = self::getAllowedInteriors();

		return count(array_intersect_key($INTERIORS, $interior)) == count($interior);
	}

	public static function isAnyInteriorAllowed($interior)
	{
		$interior = array_flip(func_get_args());

		$INTERIORS = self::getAllowedInteriors();

		return count(array_intersect_key($INTERIORS, $interior)) > 0;
	}

	public static function isInteriorAllowedAndLessonActive($interior)
	{
		return self::isLessonActive() && self::isInteriorAllowed($interior);
	}

	public static function isInteriorAllowedAndLessonInactive($interior)
	{
		return self::isLessonInactive() && self::isInteriorAllowed($interior);
	}

	public static function isAnyInteriorAllowedAndLessonActive($interior)
	{
		return self::isLessonActive() && self::isAnyInteriorAllowed($interior);
	}

	public static function currentCompanyHasDebt()
	{
		return Yii::app()->user->getState('status') == Firma::COMPANY_STATUS_DEBT;
	}

	public static function getLatestTenderActionId(CreativeUser &$student)
	{
		return Yii::app()->db->createCommand('
			select a."id" from "AkcjaUzytkownika" au
			left join "Akcja" a on a."id" = au."idAkcji"
			where a."idLekcji" = :lessonId and a."nazwa" = :tag
				and au."idFirmy" = :idFirmy
			order by au."dataWyslania" desc
		')->queryScalar(array(
			':lessonId' => $student->tura,
			':tag' => self::ACTION_TENDER,
			':idFirmy' => $student->id_firmy
		));
	}

	private function _parseActionMail(AkcjaUzytkownika &$model, CreativeUser &$student)
	{
		$bonusTasks = Firma::getBonusTasksListCount($student->id_firmy);
		if ($bonusTasks <= 0)
		{
			$model = null;
			return false;
		}

		$patterns = array('/\[foreignLink\]/i', '/\[bonusoweZlecenia\]/i');
		$replacements = array(
			CHtml::link('here', '#', array('class'=>'bonusTasksLink','data-lang'=>'en')),
			CHtml::link('tutaj', '#', array('class'=>'bonusTasksLink','data-lang'=>'')),
		);

		$model->naglowek = preg_replace($patterns, $replacements, self::parseText($this->naglowek));
		$model->tresc = preg_replace($patterns, $replacements, self::parseText($this->tresc));
		$model->przeczytana = 0;
	}

	private function _parseActionPrzetarg(AkcjaUzytkownika &$model, CreativeUser &$student)
	{
		$tenders = Przetarg::model()->with(array('kontrahent.dziedzina'))->findAllByAttributes(array(
			'idKlasy' => $student->id_klasy,
			'idAkcji' => $this->id
		));

		$template = '<ul>';
		foreach ($tenders as $tender)
			$template .= '<li>' . $tender->kontrahent->dziedzina->nazwa . ' - '
				. $tender->poziomStr . ' - <a class="gotoTender" data-kontrahentId="'
				. $tender->idKontrahenta . '" href="#">' . $tender->kontrahent->nazwa . '</a></li>';
		$template .= '</ul>';

		$model->naglowek = preg_replace('/\[LISTA\]/i', $template, $this->naglowek);
		$model->tresc = preg_replace('/\[LISTA\]/i', $template, $this->tresc);
		$model->przeczytana = 0;
	}

	private function _parseActionInfoMiesieczneOplaty7(AkcjaUzytkownika &$model, CreativeUser &$student)
	{
		$companyModel = Firma::model()->findByPk(Yii::app()->user->getState('id_firmy'));

		$model->tresc = str_replace('[oplatyMiesieczne]', $companyModel->alayzePayments(7), self::parseText($this->tresc));
		$model->przeczytana = 0;
	}

	private function _parseActionInfoMiesieczneOplaty11(AkcjaUzytkownika &$model, CreativeUser &$student)
	{
		$companyModel = Firma::model()->findByPk(Yii::app()->user->getState('id_firmy'));

		$model->tresc = str_replace('[oplatyMiesieczne]', $companyModel->alayzePayments(11), self::parseText($this->tresc));
		// change to 4000 on db update
		//if(strlen($model->tresc)>4000) // 2000
		//	$model->tresc = substr($model->tresc,0,3997)."...";
		$model->przeczytana = 0;
	}

	private function _parseActionInfoMiesieczneOplaty15(AkcjaUzytkownika &$model, CreativeUser &$student)
	{
		$companyModel = Firma::model()->findByPk(Yii::app()->user->getState('id_firmy'));

		$model->tresc = str_replace('[oplatyMiesieczne]', $companyModel->alayzePayments(15), self::parseText($this->tresc));
		// change to 4000 on db update
		//if(strlen($model->tresc)>4000) // 2000
		//	$model->tresc = substr($model->tresc,0,3997)."...";
		$model->przeczytana = 0;
	}
/*
	public static function saveNextActionAsUnread()
        {
                // get last saved,read,compulsory action
                $wybranaAkcja = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"przeczytana" > 0 AND "czyObowiazkowa" > 0',
                        'order'=>'"dataWyslania" DESC',
                        'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy')),
                ));

                // pobierz kolejna obowiazkowa akcje gdzie idRodzica = wybranaAkcja
                $nextAction = Akcja::model()->find(array(
                        'condition'=>'"czyObowiazkowa" > 0 AND "idRodzica" = :wakcja',
                        'params'=>array(':wakcja'=>$wybranaAkcja->idAkcji),
                ));

                if(isset($nextAction))
                {
                        // save child action as unread
                        $akcjaDoDodania = $nextAction->generate( Yii::app()->user, false);
                        $akcjaDoDodania->save(false);
                }
        }
*/
	public static function saveSpecificActionAsUnread($nazwaAkcji,$uzytkownik)
        {
                // pobierz akcje o podanej nazwie
                $specificAction = Akcja::model()->find(array(
                        'condition'=>'"nazwa" = :actname',
                        'params'=>array(':actname'=>$nazwaAkcji),
                ));

                if(isset($specificAction))
                {
                	$canSave = true; 

                	// some actions should not be repeated
			if($nazwaAkcji == "zalegleBiuro")
			{ // 169
				$rau = AkcjaUzytkownika::model()->find(array(
					'condition'=>'"idAkcji" = :ida AND "idUzytkownika" = :idu AND "przeczytana" = 0',
					'params'=>array(
						':ida'=>169,
						':idu'=>$uzytkownik->id,
					),
				));
				if(isset($rau))
				{
					$canSave = false;
				}
			}

			if($nazwaAkcji == "zaleglaDotacja")
			{ // 168
				$rau = AkcjaUzytkownika::model()->find(array(
					'condition'=>'"idAkcji" = :ida AND "idUzytkownika" = :idu AND "przeczytana" = 0',
					'params'=>array(
						':ida'=>168,
						':idu'=>$uzytkownik->id,
					),
				));
				if(isset($rau))
				{
					$canSave = false;
				}
			}

			if($nazwaAkcji == "zaleglyBank")
			{ // 167
				$rau = AkcjaUzytkownika::model()->find(array(
					'condition'=>'"idAkcji" = :ida AND "idUzytkownika" = :idu AND "przeczytana" = 0',
					'params'=>array(
						':ida'=>167,
						':idu'=>$uzytkownik->id,
					),
				));
				if(isset($rau))
				{
					$canSave = false;
				}
			}

			if($nazwaAkcji == "zalegleFormularze")
			{ // 164
				$rau = AkcjaUzytkownika::model()->find(array(
					'condition'=>'"idAkcji" = :ida AND "idUzytkownika" = :idu AND "przeczytana" = 0',
					'params'=>array(
						':ida'=>164,
						':idu'=>$uzytkownik->id,
					),
				));
				if(isset($rau))
				{
					$canSave = false;
				}
			}

			if($nazwaAkcji == "niezaakceptowaneFormularze")
			{ // 165
				$rau = AkcjaUzytkownika::model()->find(array(
					'condition'=>'"idAkcji" = :ida AND "idUzytkownika" = :idu AND "przeczytana" = 0',
					'params'=>array(
						':ida'=>165,
						':idu'=>$uzytkownik->id,
					),
				));
				if(isset($rau))
				{
					$canSave = false;
				}
			}

			if($nazwaAkcji == "zalegleFormularzePoDotacji")
			{ // 176
				$rau = AkcjaUzytkownika::model()->find(array(
					'condition'=>'"idAkcji" = :ida AND "idUzytkownika" = :idu AND "przeczytana" = 0',
					'params'=>array(
						':ida'=>176,
						':idu'=>$uzytkownik->id,
					),
				));
				if(isset($rau))
				{
					$canSave = false;
				}	
			}

			if($canSave)
			{
                        	// save action as unread                   
                        	$akcjaDoDodania = $specificAction->generateFromUserModel( $uzytkownik, false);
                        	$akcjaDoDodania->save(false);
                        }
                }
        }

	public static function removeSpecificAction($nazwaAkcji,$userid)
	{
		$Uobj = Uzytkownik::model()->find(array(
			'condition'=>'"id" = :usid',
			'params'=>array(':usid'=>$userid),
		));
		if($Uobj)
		{
			$firmaId = $Uobj->idFirmy;
			$akcja = Akcja::model()->find(array(
				'condition'=>'"nazwa" = :actname',
				'params'=>array(':actname'=>$nazwaAkcji),
			));
			if($akcja)
			{
                		$specificAction = AkcjaUzytkownika::model()->deleteAll(array(
                        		'condition'=>'"idAkcji" = :aid AND "idFirmy" = :id_firmy', //"idUzytkownika" = :id_uzytkownika',
                        		'params'=>array(':aid'=>$akcja->id,
                        				//':id_uzytkownika'=>$userid,
                        				':id_firmy'=>$firmaId,
                        				),
                		));
                	}
                }
	}

	public static function isBlockedAction($userid)
	{
                $ultraSpecificAction = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'zalegleFormularze',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($ultraSpecificAction))
		{
			return 2;
		}

                $specificAction = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'odrzuconyFormularz',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
                if(isset($specificAction))
                {
			return 1; // true
		}

                $isEverythingAcceptedAction = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'niezaakceptowaneFormularze',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($isEverythingAcceptedAction))
		{
			return 3;
		}

                $isBankRemaining = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'zaleglyBank',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($isBankRemaining))
		{
			return 4;
		}

		$isDonationRemaining = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'zaleglaDotacja',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($isDonationRemaining))
		{
			return 5;
		}

		$isOfficeRemaining = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'zalegleBiuro',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($isOfficeRemaining))
		{
			return 6;
		}

		$paidFormsRemaining = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'zalegleFormularzePoDotacji',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($paidFormsRemaining))
		{
			return 7;
		}

		$zalegleOplaty = AkcjaUzytkownika::model()->with('akcja')->find(array(
                        'condition'=>'"akcja"."nazwa" = :actname AND "t"."idUzytkownika" = :id_uzytkownika',
                        'params'=>array(':actname'=>'zalegleOplaty',
                        		':id_uzytkownika'=>$userid,
                        		),
                ));
		if(isset($zalegleOplaty))
		{
			return 8;
		}

		return 0; // false - NOT BLOCKED, user can continue lesson
	}

	public static function parseText($string, Uzytkownik &$student = null)
	{
		if(isset($student))
		{
			$imie = $student->imie;
			$nazwisko = $student->nazwisko;
			$idFirmy = $student->idFirmy;
			$plec = $student->plec;
			$pesel = $student->pesel;
		}
		else
		{
			$imie = Yii::app()->user->getState('imie');
			$nazwisko = Yii::app()->user->getState('nazwisko');
			$idFirmy = Yii::app()->user->getState('id_firmy');
			$plec = Yii::app()->user->getState('plec');
			$pesel = Yii::app()->user->getState('pesel');
		}

                $newstring = $string;

                // imie
                $newstring = str_replace('[imie]', $imie, $newstring);

                // nazwisko
                $newstring = str_replace('[nazwisko]', $nazwisko, $newstring);

                // imienazwisko
                $newstring = str_replace('[imienazwisko]', $imie." ".$nazwisko, $newstring);

                // firma
                $firma = Firma::model()->find(array(
                        'condition'=>'"id" = :idfirmy',
                        'params'=>array(':idfirmy'=>$idFirmy),
                ));
                if(isset($firma))
                {
                        if($firma->nazwa == "")
                                $newstring = str_replace('[firma]', "[Nienazwana firma]", $newstring);
                        else
                                $newstring = str_replace('[firma]', $firma->nazwa, $newstring);

                        $newstring = str_replace('[nip]', $firma->nip, $newstring);
                        $newstring = str_replace('[regon]', $firma->regon, $newstring);
                }

                // plec/plec
                $newstring = preg_replace('/\[(.*?)\/(.*?)\]/', $plec=="m"?"$1":"$2", $newstring);

		// pesel
                $newstring = str_replace('[pesel]', $pesel, $newstring);

		if(!isset($student))
		{
                	// numerlekcji
                	$newstring = str_replace('[numerlekcji]', Yii::app()->user->getState('tura'), $newstring);
		}

		return $newstring;
	}

	public function generateFromUserModel(Uzytkownik &$student, $przeczytana = true)
	{
		$read = ($przeczytana)? 1 : 0;

		$model = new AkcjaUzytkownika;
		$model->idAkcji = $this->id;
		$model->idUzytkownika = $student->id;
		$model->idFirmy = $student->idFirmy;
		$model->dataWyslania = new CDbExpression('SYSDATE');
		$model->naglowek = $this->parseText($this->naglowek, $student);
		$model->tresc = $this->parseText($this->tresc, $student);
		$model->przeczytana = $read;
/*
		$method = '_parseAction' . ucfirst(strtolower($this->nazwa));
		if (method_exists($this, $method))
			$this->$method($model, $student);
*/
		return $model;
	}

	public function &generate(CreativeUser &$student, $przeczytana = true)
	{
		$read = ($przeczytana)? 1 : 0;

		$model = new AkcjaUzytkownika;
		$model->idAkcji = $this->id;
		$model->idUzytkownika = $student->id;
		$model->idFirmy = $student->id_firmy;
		$model->dataWyslania = new CDbExpression('SYSDATE');
		$model->naglowek = $this->parseText($this->naglowek);
		$model->tresc = $this->parseText($this->tresc);
		$model->przeczytana = $read;
		if($read) //  && $model->dataWykonania == null)
		{
			$model->dataWykonania = new CDbExpression('SYSDATE');
		}
		else
		{
			$automatyczneWykonywanie = array(4,5,8,9,10,14,16,17,50,52,53,170,171,172);
			if(in_array($this->id,$automatyczneWykonywanie))
				$model->dataWykonania = new CDbExpression('SYSDATE');
		}

		$method = '_parseAction' . ucfirst(strtolower($this->nazwa));
		if (method_exists($this, $method))
			$this->$method($model, $student);

		return $model;
	}

	public static function pullActions($lessonNo)
	{
		$userId = Yii::app()->user->id;

		if (!Yii::app()->user->tura_aktywna)
			$lessonNo++;

		$actions = self::model()->with(array('userAction'=>array('select'=>'"id"')))->findAll(array(
			'select' => '"t"."id", "t"."nazwa", "t"."naglowek", "t"."tresc"',
			'condition' => '"t"."idLekcji" < :lessonNo and "t"."idLekcji" > 0 and
				"t"."czyAutomatyczna" > 0 and "t"."czyObowiazkowa" > 0 and
				("userAction"."id" is null or "userAction"."dataWykonania" is null)',
			'order' => '"t"."id" ASC',
			'params' => array(':userId' => $userId, ':lessonNo' => $lessonNo)
		));

		foreach ($actions as $action)
		{
			$userAction = $action->userAction;

			if (empty($userAction))
				$userAction = $action->generate(Yii::app()->user, false);
			if (!empty($userAction))
			{
				$userAction->dataWykonania = new CDbExpression('sysdate');
				//$userAction->przeczytana = 1;
				$userAction->save(false);
/*
				// is there another action like this in the same company?
               			// if there is copy the content to new one
				if($userAction->idAkcji == 173)
				{
                			$wiadomoscIstnieje = AkcjaUzytkownika::model()->find(array(
                        			'condition'=>'"idAkcji" = 173 AND "idFirmy" = :idFirmy',
						'order'=>'"dataWyslania" ASC',
                        			'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy')),
                			));
					if(isset($wiadomoscIstnieje))
						$userAction->tresc = $wiadomoscIstnieje[0]->tresc;
				}
				if($userAction->idAkcji == 174)
				{
                			$wiadomoscIstnieje = AkcjaUzytkownika::model()->find(array(
                        			'condition'=>'"idAkcji" = 174 AND "idFirmy" = :idFirmy',
						'order'=>'"dataWyslania" ASC',
                        			'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy')),
                			));
					if(isset($wiadomoscIstnieje))
						$userAction->tresc = $wiadomoscIstnieje[0]->tresc;
				}
				if($userAction->idAkcji == 175)
				{
                			$wiadomoscIstnieje = AkcjaUzytkownika::model()->find(array(
                        			'condition'=>'"idAkcji" = 175 AND "idFirmy" = :idFirmy',
						'order'=>'"dataWyslania" ASC',
                        			'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy')),
                			));
					if(isset($wiadomoscIstnieje))
						$userAction->tresc = $wiadomoscIstnieje[0]->tresc;
				}
*/
			}
		}
	}

	public static function pullMissedForms($lessonNo)
	{
		if($lessonNo < 2) return;
		// 0 definiujemy wszystkie potrzebne formularze
		/*
		id 1	Wniosek o przyznanie dofinansowania z Funduszu Pracy na podjęcie działalności gospodarczej
		id 2	CEIDG
		id 7	VAT-7K
		id 3	PIT-36
		id 4	NIP-2
		id 5	VAT-7
		id 6	Rejestracja osoby bezrobotnej
		id 8	VAT-R
		id 9	ZUS DRA
		id 10	ZUS RCA
		id 11	ZUS ZUA
		*/

		// definicje nr lekcji - nr formularza
		/*
		$lessonForms = array(
			array(),    // lekcja 0
			array(),    // lekcja 1
			array(6,1), // lekcja 2
			array(2),   // lekcja 3
			array(11),  // lekcja 4 + tu też konto w banku! kolejny rodzaj blokady?
				    // a może po prostu niech sobie później idą do banku, będzie odblokowany
				    // również w lekcji 4 wynajem biura, jeśli pominiemy lekcję 4 powinniśmy wymusić do niej powrót w jakiś sposób.
				    // również w 4 lekcji przyznanie dotacji
			array(),    // lekcja 5
			array(),    // lekcja 6
			array(),    // lekcja 7 - teoretycznie tutaj VAT-7, DRA, RCA, przypominanie o opłatach
			array(),    // lekcja 8 ^- ale chyba nie ma sensu tego blokować, mogą później pójść do tych urzędów
			array(),    // lekcja 9
			array(),    // lekcja 10
			array(),    // lekcja 11
			array(),    // lekcja 12
			array(),    // lekcja 13
			array(),    // lekcja 14
			array(),    // lekcja 15
		);
		*/

		// definicje nr lekcji - nr formularza (kumulatywne)
		$lessonForms = array(
			array(),        // lekcja 0
			array(),        // lekcja 1
			array(6,1),     // lekcja 2
			array(6,1,2),   // lekcja 3
			array(6,1,2),   // lekcja 4   +zua
			array(6,1,2,11), //,8), // lekcja 5 +vatr
			array(6,1,2,11), //,8), // lekcja 6
			array(6,1,2,11), //,8,5,9),// lekcja 7 +vat7 +dra
			array(6,1,2,11), //,8,5,9),// lekcja 8
			array(6,1,2,11), //,8,5,9),// lekcja 9
			array(6,1,2,11), //,8,5,9),// lekcja 10
			array(6,1,2,11), //,8,5,9,10),// lekcja 11 +rca
			array(6,1,2,11), //,8,5,9,10),// lekcja 12
			array(6,1,2,11), //,8,5,9,10),// lekcja 13
			array(6,1,2,11), //,8,5,9,10),// lekcja 14
			array(6,1,2,11), //,8,5,9,10),// lekcja 15
		);

		// ALGORYTM
		// 1 sprawdzamy firmę tego użytkownika
		// 2 szukamy wszystkich użytkowników z tej firmy
		// 3 szukamy wszystkich formularzy dodanych przez tych uzytkownikow
		// 4 sprawdzamy czy wszystkie które miały być dodane w poprzednich lekcjach zostały dodane i czy mają statusy różne od DRAFT
		// 5 jesli jakiegoś brakuje dodajemy go do tabeli FormularzUzytkownika jako draft i kazemy wypełniać przed przejsciem dalej

		$userId = Yii::app()->user->id;
		$idFirmy = Yii::app()->user->getState('id_firmy');

		$uzytkownicyFirmy = Uzytkownik::model()->findAll('"idFirmy" = :id_firmy', array(':id_firmy' => $idFirmy));

		$draftCount = 0;
		$addedCount = 0;
		$rejectedCount = 0;
		$acceptedCount = 0;
		$addedceidg = false;
		$addedvatr  = false;
		$addedForms = array();
		foreach($uzytkownicyFirmy as $fuser)
		{
			// sprawdzamy jakie formularze są dodane
			$forms = FormularzUzytkownika::model()->findAll('"idUzytkownika" = :id_uz', array(':id_uz' => $fuser->id));
			foreach($forms as $foo)
			{
				array_push($addedForms,$foo->idFormularza);
				$isFound = (array_search($foo->idFormularza, $lessonForms[$lessonNo-1])===null)?0:1;
				if($isFound && $foo->status==0) $draftCount++;
				if($isFound && $foo->status==2) $acceptedCount++;
				if($isFound && $foo->status==3) $rejectedCount++;
				if($isFound) $addedCount++;
				if($foo->idFormularza == 2) $addedceidg = true;
				if($foo->idFormularza == 8) $addedvatr = true;
			}
		}

		// w lekcji 3ciej CEIDG do draftów
		if($lessonNo == 3)
		{
			if(!$addedceidg)
			{
				$ceidgform = new FormularzUzytkownika;
				$ceidgform->idFormularza = 2;
				$ceidgform->idUzytkownika = $userId;
				$ceidgform->status = 0; //draft
				$ceidgform->dataModyfikacji = new CDbExpression('SYSDATE');
				$ceidgform->save(false);
			}

			$isCeidgDraft = FormularzUzytkownika::model()->find( '"idUzytkownika" = :id_uz AND "idFormularza" = 2 AND "status" = 0', array(':id_uz'=>$userId) );
			if(isset($isCeidgDraft))
			{
				$draftCount--;
			}
		}

		// returns all elements of A which are not elements of B
		$diffa = array_diff($lessonForms[$lessonNo-1],$addedForms);

		$u = Uzytkownik::model()->find(array(
                	'condition'=>'"id" = :uidd',
                	'params' => array(':uidd'=>$userId),
        	));

		if(count($diffa)>0)    // block it
		{
			// dodajemy zaległe formularze (jeśli znaleziono jakieś ominięte
			foreach($diffa as $di)
			{
				$newform = new FormularzUzytkownika;
				$newform->idFormularza = $di;
				$newform->idUzytkownika = $userId;
				$newform->status = 0;
				$newform->dataModyfikacji = new CDbExpression('SYSDATE');
				$newform->save(false);
			}

			Akcja::saveSpecificActionAsUnread("zalegleFormularze", $u);
		}
		else if($draftCount>0) // block it
		{
			// włączamy blokadę bo są drafty
			Akcja::saveSpecificActionAsUnread("zalegleFormularze", $u);
		}
		else
		{
			// sprawdzić jeszcze czy wszystkie 3 są zaakceptowane (jesli lekcja nr >= 4)
			if($rejectedCount > 0)
			{
				Akcja::removeSpecificAction("niezaakceptowaneFormularze", $u->id);
				Akcja::saveSpecificActionAsUnread("odrzuconyFormularz", $u);
			}
			else if($lessonNo > 4 && $acceptedCount<$addedCount && !($lessonNo == 5 && $addedvatr) ) // $lessonNo>=4
			{
				Akcja::removeSpecificAction("zalegleFormularze",$u->id);
				Akcja::saveSpecificActionAsUnread("niezaakceptowaneFormularze", $u);
			}
			else
			{
				Akcja::removeSpecificAction("niezaakceptowaneFormularze", $u->id);
				Akcja::removeSpecificAction("zalegleFormularze",$u->id);
			}
		}

		// czy mamy bank
		$firma = Firma::model()->find(array(
            	    'condition' => '"id" = :idFirmy',
            	    'params' => array(':idFirmy' => Yii::app()->user->getState("id_firmy")),
        	));

		// sprawdzamy, czy dotacja została już przyznana
                $donationUserAction = AkcjaUzytkownika::model()->find(array(
                        'condition'=>'"idAkcji" = 50 AND "idFirmy" = :idFirmy AND "dataWykonania" is not null',
                        'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy')),
                ));

		// sprawdzamy czy mamy jakies biuro
        	$ileMamBiur = count(BiuroFirmy::model()->findAll(array('condition' => '"idFirmy" = :idFirmy',
                    	    'params' => array(':idFirmy' => Yii::app()->user->getState('id_firmy')))));

		// brakujace akcje
        	if(isset($firma) && $lessonNo > 4)
		{
            		if(!$firma->idBanku || $firma->idBanku < 1 || $firma->idBanku > 4)
			{
				Akcja::saveSpecificActionAsUnread("zaleglyBank", $u);
				Akcja::saveSpecificActionAsUnread("zaleglaDotacja", $u);
				Akcja::saveSpecificActionAsUnread("zalegleBiuro", $u);
			}
			else if(!$donationUserAction)
			{
				Akcja::saveSpecificActionAsUnread("zaleglaDotacja", $u);
				Akcja::saveSpecificActionAsUnread("zalegleBiuro", $u);
			}
			else if($ileMamBiur <= 0)
			{
				Akcja::saveSpecificActionAsUnread("zalegleBiuro", $u);
			}
		}

		if(isset($firma) && $lessonNo > 5 && $firma->idBanku >= 1 && $firma->idBanku <= 4 && isset($donationUserAction) && $ileMamBiur > 0)
		{
			$lessonPaidForms = array(
				array(),   // lekcja 0
				array(),   // lekcja 1
				array(),   // lekcja 2
				array(),   // lekcja 3
				array(),   // lekcja 4 +zua
				array(),  // lekcja 5 +vatr
				array(8),  // lekcja 6
				array(8,5,9), // lekcja 7 +vat7 +dra
				array(8,5,9), // lekcja 8
				array(8,5,9), // lekcja 9
				array(8,5,9), // lekcja 10
				array(8,5,9,10), // lekcja 11 +rca
				array(8,5,9,10), // lekcja 12
				array(8,5,9,10), // lekcja 13
				array(8,5,9,10), // lekcja 14
				array(8,5,9,10), // lekcja 15
			);

			$PdraftCount = 0;
			$PaddedCount = 0;
			$PrejectedCount = 0;
			$PacceptedCount = 0;
			$PaddedForms = array();
			foreach($uzytkownicyFirmy as $fuser)
			{
				// sprawdzamy jakie formularze są dodane
				$forms = FormularzUzytkownika::model()->findAll('"idUzytkownika" = :id_uz', array(':id_uz' => $fuser->id));
				foreach($forms as $foo)
				{
					array_push($PaddedForms,$foo->idFormularza);
					$isFound = (array_search($foo->idFormularza, $lessonPaidForms[$lessonNo-1])===null)?0:1;
					if($isFound && $foo->status==0) $PdraftCount++;
					if($isFound && $foo->status==2) $PacceptedCount++;
					if($isFound && $foo->status==3) $PrejectedCount++;
					if($isFound) $PaddedCount++;
				}
			}

			// returns all elements of A which are not elements of B
			$diffb = array_diff($lessonPaidForms[$lessonNo-1],$PaddedForms);

			if(count($diffb)>0)    // block it
			{
				// dodajemy zaległe formularze (jeśli znaleziono jakieś ominięte
				foreach($diffb as $dbi)
				{
					$newerform = new FormularzUzytkownika;
					$newerform->idFormularza = $dbi;
					$newerform->idUzytkownika = $userId;
					$newerform->status = 0;
					$newerform->dataModyfikacji = new CDbExpression('SYSDATE');
					$newerform->save(false);
				}

				//Akcja::saveSpecificActionAsUnread("zalegleFormularze", $u); //PoDotacji", $u);
				Akcja::saveSpecificActionAsUnread("zalegleFormularzePoDotacji", $u);
			}
			else if($PdraftCount>0) // block it
			{
				// włączamy blokadę bo są drafty
				//Akcja::saveSpecificActionAsUnread("zalegleFormularze", $u); //PoDotacji", $u);
				Akcja::saveSpecificActionAsUnread("zalegleFormularzePoDotacji", $u);
			}
			else
			{
				// sprawdzić jeszcze czy wszystkie 3 są zaakceptowane (jesli lekcja nr >= 4)
				if($PrejectedCount > 0)
				{
					Akcja::removeSpecificAction("niezaakceptowaneFormularze", $u->id);
					Akcja::saveSpecificActionAsUnread("odrzuconyFormularz", $u);
				}
				else if($lessonNo >= 5 && count($diffb) > 0) //$PacceptedCount<$PaddedCount)
				{
					//Akcja::removeSpecificAction("zalegleFormularze",$u->id); //PoDotacji",$u->id);
					Akcja::removeSpecificAction("zalegleFormularzePoDotacji",$u->id);
					Akcja::saveSpecificActionAsUnread("niezaakceptowaneFormularze", $u);
				}
				else
				{
					Akcja::removeSpecificAction("niezaakceptowaneFormularze", $u->id);
					//Akcja::removeSpecificAction("zalegleFormularze",$u->id); //PoDotacji",$u->id);
					Akcja::removeSpecificAction("zalegleFormularzePoDotacji",$u->id);
				}
			}

			//Akcja::removeSpecificAction("zalegleOplaty", $u->id);

			// ochrona przed duplikatami
			$czyZaleglaOplata = AkcjaUzytkownika::model()->find(array(
                                'condition'=>'"idAkcji" = 177 AND "idFirmy" = :idFirmy',
                                'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy')),
                        ));
			$juzZaplacone = Oplaty::model()->findAll(array(
				'condition'=>'"idFirmy" = :id_firmy AND "idKontrahenta" is null AND "tytul" LIKE \'Egzekucja%\' AND "czas" >= SYSDATE-3/24',
				'params'=>array(':id_firmy'=>Yii::app()->user->getState('id_firmy')),
			));

			if($lessonNo > 7 && count($czyZaleglaOplata)==0 && count($juzZaplacone)==0 && Yii::app()->user->tura_aktywna)
			{
				$ida = 173; if($lessonNo>11) $ida = 174; if($lessonNo>15) $ida = 175;
                		$akcjaOplaty = AkcjaUzytkownika::model()->find(array(
                        		'condition'=>'"idAkcji" = :idAkcji AND "idFirmy" = :idFirmy',
					'order'=>'"id" DESC',
                        		'params'=>array(':idFirmy'=>Yii::app()->user->getState('id_firmy'),
							':idAkcji'=>$ida,
						       ),
                		));

				$egzekucje = Oplaty::model()->findAll(array(
					'condition'=>'"idFirmy" = :id_firmy AND "idKontrahenta" is null AND "tytul" LIKE \'Egzekucja%\'',
					'params'=>array(':id_firmy'=>Yii::app()->user->getState('id_firmy')),
				));
				$numex = isset($egzekucje) ? count($egzekucje) : 0;

				if( isset($akcjaOplaty) && ( ($lessonNo>15&&$numex==2)||($lessonNo>11&&$numex==1)||($lessonNo>7&&$numex==0) ) )
				{
					$tmptresc = strip_tags($akcjaOplaty->tresc,'<a>');
					preg_match_all('/data-kontrahentid=["|\'](.*?)["|\']/i',$tmptresc,$matchesk);
					$kontrahents = $matchesk[1];
					preg_match_all('/data-title=["|\'](.*?)["|\']/i',$tmptresc,$matchest);
					$titles = $matchest[1];
					preg_match_all('/data-wartosc=["|\'](.*?)["|\']/i',$tmptresc,$matchesw);
					$wartoscs = $matchesw[1];
/*
Yii::log(CVarDumper::dumpAsString($kontrahents));
Yii::log(CVarDumper::dumpAsString($titles));
Yii::log(CVarDumper::dumpAsString($wartoscs));
*/
					$ilosc_zaplaconych = 0;
					$pozostala_kwota = 0.0;
					$lista_niezaplaconych = "";

					$niezaplaceni = array();
					for ( $i=0 ; $i<count($kontrahents) ; $i++ )
					{
						$oplaty = Oplaty::model()->findAll(array(
							'condition'=>'"idFirmy" = :id_firmy AND "idKontrahenta" = :id_kontrahenta',
							'order'=>'"id" DESC',
							'params'=>array(
								':id_firmy'=>Yii::app()->user->getState('id_firmy'),
								':id_kontrahenta'=>$kontrahents[$i],
							),
						));
						$change = false;
						foreach( $oplaty as $opl )
						{
							if( floatval($opl->wartosc) == -floatval($wartoscs[$i]) )
							{
								$ilosc_zaplaconych++;
								$change = true;
								break;
							}
						}
						if(!$change) array_push($niezaplaceni, $i);
//						if($ilosc_zaplaconych!=$i+1)
//						{
//							$pozostala_kwota += floatval($wartoscs[$i]);
//							$lista_niezaplaconych .= $titles[$i]." - ".number_format(floatval($wartoscs[$i]), 2, ',', '')."<br/>";
//						}
					}

                                        foreach($niezaplaceni as $zap)
                                        {
                                                $pozostala_kwota += floatval($wartoscs[$zap]);
                                                $lista_niezaplaconych .= $titles[$zap]." - ".number_format(floatval($wartoscs[$zap]), 2, ',', '')."<br/>";
                                        }


					if($ilosc_zaplaconych < count($kontrahents) && $pozostala_kwota > 0)
					{
                				// pobierz akcje o podanej nazwie
                				$specificAction = Akcja::model()->find(array(
                        				'condition'=>'"nazwa" = :actname',
                        				'params'=>array(':actname'=>"zalegleOplaty"),
                				));

                				if(isset($specificAction) && !isset($czyZaleglaOplata) && count($juzZaplacone)==0)
                				{
							$transaction = Yii::app()->db->beginTransaction();
							try
							{
								$title = 'Egzekucja komornicza zaległych należności';

								// sprawdzamy czy sie nie powtarza w dniu dzisiejszym
                        					$repeatedTransfer = Oplaty::model()->find(array(	
                                					'condition'=>'"tytul" LIKE \'%Egzekucja%\' AND "idFirmy" = :idfirmy AND "czas" >= SYSDATE-3/24',
                                					'params'=>array(
                                        					'idfirmy'=>Yii::app()->user->getState('id_firmy'),
                                					)
                        						/*
                                					'condition'=>'"tytul" = \':title\' AND "idFirmy" = :idfirmy AND "czas" >= trunc(SYSDATE)',
                                					'params'=>array(
                                        					'title'=>$title,
                                        					'idfirmy'=>Yii::app()->user->getState('id_firmy'),
                                					)
                                					*/
                        					));

                        					if(isset($repeatedTransfer))
                                					throw new Exception('Transakcja została już wykonana.');

								$payment = new Oplaty;
								$payment->idBanku = $firma->idBanku;
								$payment->idFirmy = $firma->id;
								$payment->rodzajOplaty = Oplaty::TYPE_BANK;
								$payment->tytul = $title;
								$payment->wartosc = -number_format($pozostala_kwota, 2, ',', '');
								$payment->czas = new CDbExpression('SYSDATE');
								$payment->save(false);

								$firma->stanKonta -= $pozostala_kwota;
								$firma->updated = true;

                        					// save action as unread
                        					$akcjaDoDodania = $specificAction->generateFromUserModel( $u, false );
								$akcjaDoDodania->tresc = "System wykrył, iż podczas poprzedniej lekcji nie wykonano następujących obowiązkowych opłat:<br/>".$lista_niezaplaconych."<br/>W związku z powyższym, w dniu dzisiejszym komornik pobrał z Państwa konta zaległe należności.";
                        					$akcjaDoDodania->save(false);

								$firma->save(false);
								$transaction->commit();

								//Akcja::removeSpecificAction("zalegleOplaty", Yii::app()->user->id);
							}
							catch (Exception $e)
							{
								/*echo '<script type="text/javascript"> console.log('.$e->getMessage().'); </script>';*/
								$transaction->rollback();
							}
                				}
					}
				}
			}
		}
	}

}
